﻿<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Place" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Obniżone składki zdrowotne - zestawienie</title>
		<script runat="server">

	class Składka {
		public decimal podstawa;
		public decimal składka;
		public void Add(ISkładka skł) {
			podstawa += skł.Podstawa;
			składka += skł.Prac + skł.Firma;
		}		
	}
	class PracTotal: IComparable {
		Hashtable składki = new Hashtable();
		readonly Pracownik pracownik;
		PracHistoria historia;
		decimal obliczona;
		decimal pobrana;		
		public PracTotal(Pracownik pracownik) {
			this.pracownik = pracownik;
		}
		public Pracownik Pracownik {
			get { return pracownik; }
		}
		public PracHistoria Historia {
			get { return historia; }
		}
		public void Add(WypElement element) {
			Składka skł = (Składka)składki[element.Podatki.TyUb];
			if (skł==null) {
				skł = new Składka();
				składki.Add(element.Podatki.TyUb, skł);
			}
			skł.Add(element.Podatki.Zdrowotna);
		}		
		public bool Przelicz(Date data, Percent procent) {
			foreach (Składka skł in składki.Values) {
				decimal podstawa = skł.podstawa;
				obliczona += Soneta.Tools.Math.RoundCy(podstawa * procent);
				pobrana += skł.składka;
			}
			if (obliczona==pobrana)
				return false;
				
			historia = pracownik[data];	
			return true;
		}
		public decimal Obliczona {
			get { return obliczona; }
		}
		public decimal Pobrana {
			get { return pobrana; }
		}
		public decimal Różnica {
			get { return obliczona - pobrana; }
		}
		public int CompareTo(object obj) {
			if (obj==null)
				return 1;
			PracTotal pt = obj as PracTotal;
			if (pt==null)
				throw new ArgumentException();
			return pracownik.NazwiskoImię.CompareTo(pt.Pracownik.NazwiskoImię);
		}
	}
	class KasaTotal: IComparable {
		ArrayList prac = new ArrayList();
		readonly string nazwa;
		public KasaTotal(string nazwa) {
			this.nazwa = nazwa;
		}
		public void Add(PracTotal pt) {
			prac.Add(pt);
		}
		public string Nazwa {
			get { return nazwa; }
		}
		public IEnumerable Pracownicy {
			get { 
				prac.Sort();
				return prac; 
			}
		}
		public int CompareTo(object obj) {
			if (obj==null)
				return 1;
			KasaTotal kt = obj as KasaTotal;
			if (kt==null)
				throw new ArgumentException();
			return nazwa.CompareTo(kt.nazwa);
		}
	}
							
	public class PrnParams: ContextBase {
	
		public PrnParams(Context context): base(context) {
			Date date = Date.Empty;
			if (context.Contains(typeof(ActualDate)))
				date = ((ActualDate)context[typeof(ActualDate)]).Actual;
			else
				date = Date.Today;
			miesiąc = new YearMonth(date);
		}
		
		YearMonth miesiąc;
		public YearMonth Miesiąc {
			get { return miesiąc; }
			set { miesiąc = value; }
		}			
	}
	
	PrnParams pars = null; 
	[Context(Required=true)] 
	public PrnParams Params { 
		get { return pars; } 
		set { pars = value; } 
	} 
		
    void OnContextLoad(Object sender, EventArgs args) {
		FromTo okres = pars.Miesiąc.ToFromTo();
		PlaceModule płace = PlaceModule.GetInstance(pars);
		
        Hashtable pracownicy = new Hashtable();
        SubTable wypłaty = new SubTable(płace.Wyplaty.WgData, okres);
        foreach (Wyplata w in wypłaty) {
			PracTotal pt = (PracTotal)pracownicy[w.Pracownik];
			if (pt==null) {
				pt = new PracTotal(w.Pracownik);
				pracownicy.Add(pt.Pracownik, pt);
			}
			foreach (WypElement e in w.Elementy)
				pt.Add(e);
		}
		
		Hashtable kasy = new Hashtable();
		Percent procent = płace.Config.SkładkiZUS.Zdrowotna[okres.To];		
		foreach (PracTotal pt in pracownicy.Values)
			if (pt.Przelicz(okres.To, procent)) {
				string kasa = pt.Historia.OddzialNFZ.Nazwa;
				KasaTotal kt = (KasaTotal)kasy[kasa];
				if (kt==null) {
					kt = new KasaTotal(kasa);
					kasy.Add(kasa, kt);
				}
				kt.Add(pt);
			}
				
		ArrayList lista = new ArrayList(kasy.Values);				
		lista.Sort();
        DataRepeater1.DataSource = lista;
	}
	
    void OnBeforeRow(Object sender, EventArgs args) {
		KasaTotal kt = (KasaTotal)DataRepeater1.CurrentRow;
		ReportHeader1.Title = string.Format(
			"{0}|Zestawienie o obniżonych składkach na ubezpieczenie zdrowotne za {1}",
			kt.Nazwa, pars.Miesiąc.ToString());
    }
	
	static void Msg(string msg) {
	}
	
		</script>
		
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="ObniżoneSkładkiZdrowotneZestawienie" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext><BR>
			<ea:DataRepeater id="DataRepeater1" runat="server" Width="100%" Height="196px" onbeforerow="OnBeforeRow">
				<ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False"></ea:PageBreak>
				<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="?" runat="server"></cc1:ReportHeader>
				<ea:Grid id="Grid1" runat="server" DataMember="Pracownicy">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp."  NoWrap="True"></ea:GridColumn>
						<ea:GridColumn Width="25" DataMember="Pracownik.NazwiskoImię" Caption="Nazwisko i imię"  NoWrap="True"></ea:GridColumn>
						<ea:GridColumn Width="30" DataMember="Historia.Adres" Caption="Adres"  NoWrap="True"></ea:GridColumn>
						<ea:GridColumn Width="12" DataMember="Historia.PESEL" Caption="PESEL"  NoWrap="True"></ea:GridColumn>
						<ea:GridColumn Width="12" DataMember="Historia.NIP" Total="Info" Caption="NIP"  NoWrap="True"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Obliczona" Total="Sum" Caption="Składka&lt;br&gt;obliczona"  Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Pobrana" Caption="Składka&lt;br&gt;pobrana"  Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="R&#243;żnica" Total="Sum" Caption="R&#243;żnica"  Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:Grid>
				<cc1:ReportFooter id="ReportFooter1" runat="server" Height="126px"></cc1:ReportFooter>
			</ea:DataRepeater>
		</form>
	</body>
</HTML>

